/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.structure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_3499;

public class StructureInfo
implements Predicate<class_2338> {
    public Map<class_2338, class_3499.class_3501> data = new HashMap<class_2338, class_3499.class_3501>();
    public final int structureHeight;
    public final int structureLength;
    public final int structureWidth;
    public final int maxBlockIndex;
    public int showLayer = -1;
    public int blockIndex;

    public StructureInfo(List<class_3499.class_3501> structure) {
        int structureHeight = 0;
        int structureWidth = 0;
        int structureLength = 0;
        for (class_3499.class_3501 block : structure) {
            structureHeight = Math.max(structureHeight, block.comp_1341().method_10264() + 1);
            structureWidth = Math.max(structureWidth, block.comp_1341().method_10260() + 1);
            structureLength = Math.max(structureLength, block.comp_1341().method_10263() + 1);
            this.data.put(block.comp_1341(), block);
        }
        this.maxBlockIndex = this.blockIndex = structureHeight * structureLength * structureWidth;
        this.structureHeight = structureHeight;
        this.structureLength = structureLength;
        this.structureWidth = structureWidth;
    }

    public void setShowLayer(int layer) {
        this.showLayer = layer;
        if (layer < 0) {
            this.reset();
        } else {
            this.blockIndex = (layer + 1) * (this.structureLength * this.structureWidth) - 1;
        }
    }

    public void reset() {
        this.blockIndex = this.maxBlockIndex;
    }

    public void step() {
        int start = this.blockIndex;
        do {
            if (++this.blockIndex < this.maxBlockIndex) continue;
            this.blockIndex = 0;
        } while (this.isEmpty(this.blockIndex) && this.blockIndex != start);
    }

    private boolean isEmpty(int index) {
        int r = index % (this.structureLength * this.structureWidth);
        int x = r / this.structureWidth;
        int y = index / (this.structureLength * this.structureWidth);
        int z = r % this.structureWidth;
        return !this.data.containsKey(new class_2338(x, y, z));
    }

    public int getLimiter() {
        return this.blockIndex;
    }

    @Override
    public boolean test(class_2338 blockPos) {
        int index = blockPos.method_10260() + this.structureWidth * (blockPos.method_10263() + this.structureLength * blockPos.method_10264());
        return index <= this.getLimiter();
    }
}

